/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room;

import com.mojang.authlib.GameProfile;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.location.IDimensionalBlockPosition;
import dev.compactmods.machines.api.location.IDimensionalPosition;
import dev.compactmods.machines.config.ServerConfig;
import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.location.LevelBlockPosition;
import dev.compactmods.machines.machine.graph.DimensionMachineGraph;
import dev.compactmods.machines.room.RoomSize;
import dev.compactmods.machines.room.data.CompactRoomData;
import dev.compactmods.machines.room.exceptions.NonexistentRoomException;
import dev.compactmods.machines.util.CompactStructureGenerator;
import dev.compactmods.machines.util.MathUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.naming.OperationNotSupportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Rooms {
    public static ChunkPos createNew(MinecraftServer serv, RoomSize size, UUID owner) throws MissingDimensionException {
        ServerLevel compactWorld = serv.m_129880_(Registration.COMPACT_DIMENSION);
        if (compactWorld == null) {
            throw new MissingDimensionException();
        }
        CompactRoomData rooms = CompactRoomData.get(compactWorld);
        int nextPosition = rooms.getNextSpiralPosition();
        Vec3i location = MathUtil.getRegionPositionByIndex(nextPosition);
        int centerY = (Integer)ServerConfig.MACHINE_FLOOR_Y.get() + size.getInternalSize() / 2;
        BlockPos newCenter = MathUtil.getCenterWithY(location, centerY);
        CompactStructureGenerator.generateCompactStructure((LevelAccessor)compactWorld, size, newCenter);
        ChunkPos machineChunk = new ChunkPos(newCenter);
        try {
            rooms.createNew().owner(owner).size(size).chunk(machineChunk).register();
        }
        catch (OperationNotSupportedException e) {
            CompactMachines.LOGGER.warn((Object)e);
        }
        return machineChunk;
    }

    public static Stream<IDimensionalBlockPosition> getConnectedMachines(MinecraftServer server, ChunkPos room) {
        return server.m_129784_().stream().map(arg_0 -> ((MinecraftServer)server).m_129880_(arg_0)).filter(Objects::nonNull).filter(sl -> sl.m_8895_().f_78144_.containsKey("machine_connections")).flatMap(sl -> {
            DimensionMachineGraph graph = DimensionMachineGraph.forDimension(sl);
            return graph.getMachinesFor(room).stream().map(bp -> new LevelBlockPosition((ResourceKey<Level>)sl.m_46472_(), (BlockPos)bp));
        });
    }

    public static RoomSize sizeOf(MinecraftServer server, ChunkPos room) throws NonexistentRoomException {
        ServerLevel compactDim = server.m_129880_(Registration.COMPACT_DIMENSION);
        return CompactRoomData.get(compactDim).getData(room).getSize();
    }

    public static IDimensionalPosition getSpawn(MinecraftServer server, ChunkPos room) {
        ServerLevel compactDim = server.m_129880_(Registration.COMPACT_DIMENSION);
        return CompactRoomData.get(compactDim).getSpawn(room);
    }

    public static boolean exists(MinecraftServer server, ChunkPos room) {
        ServerLevel compactDim = server.m_129880_(Registration.COMPACT_DIMENSION);
        return CompactRoomData.get(compactDim).isRegistered(room);
    }

    public static StructureTemplate getInternalBlocks(MinecraftServer server, ChunkPos room) throws MissingDimensionException, NonexistentRoomException {
        StructureTemplate tem = new StructureTemplate();
        ServerLevel compactDim = server.m_129880_(Registration.COMPACT_DIMENSION);
        CompactRoomData data = CompactRoomData.get(compactDim);
        CompactRoomData.RoomData roomInfo = data.getData(room);
        AABB bounds = roomInfo.getRoomBounds();
        int inside = roomInfo.getSize().getInternalSize();
        tem.m_163802_((Level)compactDim, new BlockPos(bounds.f_82288_, bounds.f_82289_ - 1.0, bounds.f_82290_), new Vec3i(inside, inside + 1, inside), false, null);
        return tem;
    }

    public static void resetSpawn(MinecraftServer server, ChunkPos room) throws NonexistentRoomException {
        if (!Rooms.exists(server, room)) {
            throw new NonexistentRoomException(room);
        }
        ServerLevel compactDim = server.m_129880_(Registration.COMPACT_DIMENSION);
        CompactRoomData data = CompactRoomData.get(compactDim);
        CompactRoomData.RoomData roomInfo = data.getData(room);
        Vec3 centerPoint = Vec3.m_82512_((Vec3i)roomInfo.getCenter());
        Vec3 newSpawn = centerPoint.m_82492_(0.0, (double)((float)roomInfo.getSize().getInternalSize() / 2.0f), 0.0);
        data.setSpawn(room, newSpawn);
    }

    public static Optional<String> getRoomName(MinecraftServer server, ChunkPos room) throws NonexistentRoomException {
        if (!Rooms.exists(server, room)) {
            throw new NonexistentRoomException(room);
        }
        ServerLevel compactDim = server.m_129880_(Registration.COMPACT_DIMENSION);
        CompactRoomData data = CompactRoomData.get(compactDim);
        CompactRoomData.RoomData roomInfo = data.getData(room);
        return roomInfo.getName();
    }

    public static Optional<GameProfile> getOwner(MinecraftServer server, ChunkPos room) {
        if (!Rooms.exists(server, room)) {
            return Optional.empty();
        }
        ServerLevel compactDim = server.m_129880_(Registration.COMPACT_DIMENSION);
        CompactRoomData data = CompactRoomData.get(compactDim);
        try {
            CompactRoomData.RoomData roomInfo = data.getData(room);
            UUID ownerUUID = roomInfo.getOwner();
            return server.m_129927_().m_11002_(ownerUUID);
        }
        catch (NonexistentRoomException e) {
            return Optional.empty();
        }
    }

    public static void updateName(MinecraftServer server, ChunkPos room, String newName) throws NonexistentRoomException {
        if (!Rooms.exists(server, room)) {
            throw new NonexistentRoomException(room);
        }
        ServerLevel compactDim = server.m_129880_(Registration.COMPACT_DIMENSION);
        CompactRoomData data = CompactRoomData.get(compactDim);
        CompactRoomData.RoomData roomInfo = data.getData(room);
        roomInfo.setName(newName);
        data.m_77762_();
    }
}

